package w83b.w83bManager;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bListImpugnacionesBean;
import w83b.w83bBeans.W83bRegistroDefinitivoBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;


public class W83bRegistroDefinitivo implements W83bIRegistroDefinitivo {
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIRegistroDefinitivo#comprobarFechaRegistro(java.lang.String)
	 */
	public w83b.w83bBeans.W83bRegistroDefinitivoBean comprobarFechaRegistro(java.lang.String param) throws Exception{
	
		W83bRegistroDefinitivoBean rd = W83bFactoriaDAO.getRegistroDefinitivoDAO().comprobarFechaRegistro(param);
		
		return rd;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIRegistroDefinitivo#calcularNumeroRegistro(w83b.w83bBeans.W83bRegistroDefinitivoBean)
	 */
	public java.lang.String calcularNumeroRegistro(w83b.w83bBeans.W83bRegistroDefinitivoBean param) throws Exception{
		
		String numRegistro = W83bFactoriaDAO.getRegistroDefinitivoDAO().calcularNumeroRegistro(param);
		
		return numRegistro;	
	}
	
	
	
/* (non-Javadoc)
 * @see w83b.w83bManager.W83bIRegistroDefinitivo#realizarRegistroDefinitivo(w83b.w83bBeans.W83bRegistroDefinitivoBean)
 */
public java.util.HashMap realizarRegistroDefinitivo(java.util.HashMap param) throws Exception{
	HashMap la = new HashMap();
	ArrayList listaActas=(ArrayList)param.get("listaActas");
		
	for (int i=0; i<listaActas.size(); i++){
		W83bRegistroDefinitivoBean registro = (W83bRegistroDefinitivoBean)listaActas.get(i);
		W83bFactoriaDAO.getRegistroDefinitivoDAO().modificarActaRegistroDefinitivo(registro,(W83bRegistroDefinitivoBean)param.get("registroDefinitivoBean"),i);
		registro.setUsuarioBean(((W83bRegistroDefinitivoBean)param.get("registroDefinitivoBean")).getUsuarioBean());
		W83bFactoriaDAO.getRegistroDefinitivoDAO().anyadirHistorialTramitacion(registro);
		registro.setNumRegistroDefinitivo(i+Integer.parseInt(((W83bRegistroDefinitivoBean)param.get("registroDefinitivoBean")).getNumRegistro()));
		registro.setAnnoRegistro(((W83bRegistroDefinitivoBean)param.get("registroDefinitivoBean")).getAnnoRegistro());
		registro.setTerritorio(((W83bRegistroDefinitivoBean)param.get("registroDefinitivoBean")).getTerritorio());
	}
	la.put("listaActas", listaActas);
	return la;	
	}

/* (non-Javadoc)
 * @see w83b.w83bManager.W83bIRegistroDefinitivo#consultarActasRegistroDefinitivo(w83b.w83bBeans.W83bRegistroDefinitivoBean)
 */
public java.util.HashMap consultarActasRegistroDefinitivo(w83b.w83bBeans.W83bRegistroDefinitivoBean param) throws Exception{

	return consultarActas(param);	
}

public java.util.HashMap consultarActas(w83b.w83bBeans.W83bRegistroDefinitivoBean param) throws Exception{
	HashMap listaactas=new HashMap();
	boolean impugcorrecta=true;
	List listaActasDef=new ArrayList();
	List listaActas=W83bFactoriaDAO.getRegistroDefinitivoDAO().consultarActasRegistroDefinitivo(param);
	List resultado = new ArrayList();
	List actasvivas = new ArrayList();
	boolean validoActaviva=true;
	for (int i=0;i<listaActas.size();i++){
		W83bRegistroDefinitivoBean rdb = (W83bRegistroDefinitivoBean)listaActas.get(i);
		boolean valido=W83bFactoriaDAO.getRegistroDefinitivoDAO().numdelegadosescrtdif(rdb);
		validoActaviva=true;
		if (rdb.getActatotal()==null){
			resultado = W83bFactoriaDAO.getRegistroDefinitivoDAO().validarActaViva(
					(String)rdb.getCodcentro() ,(String)rdb.getIdioma());
			
			if(null!=resultado 
					&&0<resultado.size()
					&&StringUtils.isNotEmpty((String)resultado.get(0))){
				String fechaEleccionMaxima = (String)resultado.get(0);
				String fechaEleccion = (String)rdb.getFechaeleccion();
				
				Date fechaEleccionMaximaDate = W83bDateUtil.getInstance().getDate(fechaEleccionMaxima,W83bDateUtil.getInstance().devolverFormatoIdioma((String)rdb.getIdioma()));
				Date fechaEleccionDate = W83bDateUtil.getInstance().getDate(fechaEleccion,W83bDateUtil.getInstance().devolverFormatoIdioma((String)rdb.getIdioma()));
				
				fechaEleccionMaximaDate = W83bDateUtil.getInstance().addYears(fechaEleccionMaximaDate,4);
				
				resultado = new ArrayList();//NOPMD
				if(fechaEleccionDate.compareTo(fechaEleccionMaximaDate)<0){
					actasvivas.add((String)rdb.getTerritorio()+"/"+(String)rdb.getAnoacta()+"/"+(String)rdb.getNumeroActa());
					validoActaviva=false;				
				}
			}
		}
		if (valido&&validoActaviva){
			impugcorrecta=true;
			List lpreavisos=W83bFactoriaDAO.getRegistroDefinitivoDAO().impugnacionesCorrectasPreavisos(rdb);
			for (int j=0;j<lpreavisos.size();j++){
				W83bListImpugnacionesBean lp = (W83bListImpugnacionesBean)lpreavisos.get(j);
				if (lp.getNumImpugnacion()!=null){
					if ((lp.getResultadoLaudo() != null && "1".equals(lp.getResultadoLaudo())) || (lp.getResultadoLaudo() == null && lp.getFechaDeses() == null)){
						impugcorrecta=false;
						break;
					}
				}
			}
			if (impugcorrecta){
				W83bRegistroDefinitivoBean mun=W83bFactoriaDAO.getRegistroDefinitivoDAO().obtenerMunicipio(rdb);
				rdb.setIdcomarca(mun.getIdcomarca());
				rdb.setMunicipio(mun.getDescmunicipio());
				listaActasDef.add(rdb);
			}
		}
	}
	listaactas.put("actasvivas", actasvivas);
	listaactas.put("listaActas", listaActasDef);
	return listaactas;	
}

public java.util.HashMap deshacerRegistro(w83b.w83bBeans.W83bRegistroDefinitivoBean param) throws Exception{
	
	HashMap resultado=new HashMap();
	int numincidencias;
	String fechamaxima=W83bFactoriaDAO.getRegistroDefinitivoDAO().calcularFechaRegistroMaxima(param);
	resultado.put("fechamaxima", fechamaxima);
	List lista=W83bFactoriaDAO.getRegistroDefinitivoDAO().calcularActasFechaRegMax(param, fechamaxima);
	List listaincidencias=new ArrayList();
	List listaactasunica=new ArrayList();
	if (lista.size()>0){
		if (Integer.parseInt(W83bFactoriaDAO.getRegistroDefinitivoDAO().calcularNumActasNuevas(param,fechamaxima))>0){
			//No se puede realizar el deshacer registro
			resultado.put("listaincidencias", new ArrayList());
			resultado.put("result", "2");
		}
		else{
			for (int i=0; i<lista.size();i++){
				W83bRegistroDefinitivoBean acta=(W83bRegistroDefinitivoBean)lista.get(i);
				if (Integer.parseInt(acta.getVer())==0){
					numincidencias=Integer.parseInt(W83bFactoriaDAO.getRegistroDefinitivoDAO().calcularNumIncidActa(acta));
					if (numincidencias>0){
						//Se puede realizar el deshacer registro si se descartan las incicencias
						listaincidencias.add(acta);
					}
					listaactasunica.add(acta);
				}
			}
			if (listaincidencias.size()==0){
				//Se puede realizar el deshacer registro
				resultado.put("result", "0");
				resultado.put("lista", listaactasunica);
				resultado.put("listaincidencias", new ArrayList());
			}
			else{
				resultado.put("result", "1");
				resultado.put("lista", listaactasunica);
				resultado.put("listaincidencias", listaincidencias);
			}			
		}
	}
	else{
		resultado.put("listaincidencias", new ArrayList());
		resultado.put("result", "-1");
	}
	return resultado;
	}

	public java.lang.String modificarRegistro(java.util.HashMap param) throws Exception{
		String error="0";
		try{
			List lista = (List)param.get("lista");
			for (int i=0; i<lista.size();i++){
				W83bRegistroDefinitivoBean acta=(W83bRegistroDefinitivoBean)lista.get(i);
				W83bRegistroDefinitivoBean mun=W83bFactoriaDAO.getRegistroDefinitivoDAO().obtenerMunicipio(acta);
				acta.setMunicipio(mun.getDescmunicipio());
				//Modificar tabla actas
				W83bFactoriaDAO.getRegistroDefinitivoDAO().modDatosRegistroActa(acta);    
				//Modificar tabla tramitacion
				W83bFactoriaDAO.getRegistroDefinitivoDAO().borrarHistTramActa(acta);	    
			}
		}
		catch (Exception e){
			W83bClsTrazas.trazaError(null, "ERROR en MANAGER==>modificarRegistro=="+e.getMessage(),null);
			error="-1";
		}
	return error;
	}
	
	public java.lang.String regCambiarEstadoInc(java.util.HashMap param) throws Exception{
		String error="0";
		try{
			List lista = (List)param.get("listaincidencias");
			for (int i=0; i<lista.size();i++){
				W83bRegistroDefinitivoBean acta=(W83bRegistroDefinitivoBean)lista.get(i);
				//Modificar estado incidencias
				W83bFactoriaDAO.getRegistroDefinitivoDAO().cambiarEstadoIncidencias(acta); 
				//Modificar datos acta
				W83bFactoriaDAO.getRegistroDefinitivoDAO().modDatosIncidActa(acta);	    
			}
			modificarRegistro(param);
		}
		catch (Exception e){
			W83bClsTrazas.trazaError(null, "ERROR en MANAGER==>regCambiarEstadoInc=="+e.getMessage(),null);
			error="-1";
		}
		return error;
	}


}






